IF EXISTS( SELECT *
    FROM sys.objects
    WHERE object_id = OBJECT_ID(N'[dbo].[P_EST_PRECIFICACAO_ATUALIZACAO_PRECO]')
          AND type IN(N'P', N'PC')
)
    DROP PROCEDURE [dbo].[P_EST_PRECIFICACAO_ATUALIZACAO_PRECO];
GO 
/*
=======================================================================================
'Job.................: Linx - Atualizacao de precos
'Função..............: 
'Objetivo............:  
'Tabelas.............: 
'Dt Modificação......: 22/06/2021
'Modificação.........: Tag #A001 Realizar atualização de preço por familia via agendamento  
'=======================================================================================
Tag #A001 - Alteração do codigo  
Tag #I001 - Inclusão de novo codigo 
*/
--P_EST_PRECIFICACAO_ATUALIZACAO_PRECO 0,0
CREATE PROCEDURE [dbo].[P_EST_PRECIFICACAO_ATUALIZACAO_PRECO](@CONSULTA INT = 0, @RODARIMEDIATO INT = 0)

WITH ENCRYPTION
AS


    SET NOCOUNT ON;
	
/*::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::	  
  APLICAR PREÇO NA FAMILIA DO PRODUTO
  :::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::: */
	EXEC P_INCLUI_PRECO_FAMILIA NULL



	DECLARE @DT_BASE DATE;
	SET @DT_BASE = GETDATE();
	PRINT 'Inicio processo '+CONVERT(VARCHAR(10), GETDATE(), 108);
		
    IF OBJECT_ID('TEMPDB.DBO.#TMP_PROD_KIT') IS NOT NULL
		BEGIN
			DROP TABLE #TMP_PROD_KIT;
		END;

    CREATE TABLE #TMP_MAJORADO
					(CD_EMP         INT,
					 CD_GRUPO		INT,
					 CD_FILIAL      INT,
					 CD_PROD        INT,
					 PERC_MARGEM    MONEY,
					 TIPO_MAJORACAO INT,
					 CD_GRUPO_MJ		VARCHAR(100));

    CREATE TABLE #TMP_PROD_KIT
				    (CD_EMP         INT,
				    CD_GRUPO       INT,
				    CD_PROD        INT,
				    DT_ATUALIZACAO DATETIME,
				    CD_USU         INT);

	CREATE TABLE #RsProdPend (CD_EMP INT,
							   CD_FILIAL INT,
							   CD_PROD INT)
								
	INSERT INTO 
		#RsProdPend
	SELECT
		CD_EMP,
		CD_FILIAL,
		CD_PROD
	FROM
		EST_PROD_CPL_EST_PROD_PRECO_SEM_CADASTRO				
	 
	PRINT 'Insere os produtos novos na tabela de  precos - Time'+CONVERT(VARCHAR, GETDATE(), 108);				
	IF @CONSULTA = 0
         BEGIN
             /***********************************************************************************************************************************/
             --Pegando produto sem preco  
             INSERT INTO 
				EST_PROD_PRECO
					 (CD_EMP
					, CD_FILIAL
					, CD_CTR
					, CD_PROD
					, VLR_TABELA
					, VLR_OFERTA
					, DT_CAD
					, CD_USU
					, STS_PRECO
					, VLR_CUSTO
					, PERC_ICMS
					, PERC_IMP
					, PERC_COMIS
					, PERC_DESP
					, PERC_MARGEM
					, STS_IMP_ETQ_GOND
					, VLR_TABELA_ANT
					, VLR_OFERTA_ANT
					, VLR_CUSTO_GER
					, ORIG_PRECO)
            SELECT 
				P.CD_EMP
                , P.CD_FILIAL
                , 0 AS CD_CTR
                , P.CD_PROD
                , 0 AS VLR_TABELA
                , 0 AS VLR_OFERTA
                , CONVERT( CHAR(10), GETDATE(), 112) AS DT_CAD
                , 1 AS CD_USU
                , 0 AS STS_PRECO
                , 0 AS VLR_CUSTO
                , 0 AS PERC_ICMS
                , 0 AS PERC_IMP
                , 0 AS PERC_COMIS
                , 0 AS PERC_DESP
                , 0 AS PERC_MARGEM
                , 0 AS STS_IMP_ETQ_GOND
                , 0 AS VLR_TABELA_ANT
                , 0 AS VLR_OFERTA_ANT
                , 0 AS VLR_CUSTO_GER
                , 0 AS ORIG_PRECO
            FROM
				#RsProdPend P
				LEFT OUTER JOIN EST_PROD_PRECO ON 
					P.CD_EMP = EST_PROD_PRECO.CD_EMP
					AND P.CD_FILIAL = EST_PROD_PRECO.CD_FILIAL
					AND P.CD_PROD = EST_PROD_PRECO.CD_PROD
				INNER JOIN EST_PROD ON 
					P.CD_EMP = EST_PROD.CD_EMP
					AND P.CD_PROD = EST_PROD.CD_PROD
                WHERE 
					P.CD_EMP = 1
					AND EST_PROD_PRECO.CD_PROD IS NULL
					AND EST_PROD.STS_PROD IN(0, 2);
		
/***********************************************************************************************************************************/
         END;

	INSERT INTO 
		EST_PROD_PRECIFICACAO_PRECO_ATUALIZACAO
    SELECT 
		T.CD_EMP
		, T.CD_GRUPO
		, T.CD_PROD
		, CONVERT( CHAR(10), GETDATE(), 112)
		, 0
		, 0
		, 0
		, 0
    FROM
		EST_PROD_PRECIFICACAO_PRECO T
		LEFT JOIN EST_PROD_PRECIFICACAO_PRECO_ATUALIZACAO A ON 
			T.CD_EMP = A.CD_EMP
			AND T.CD_GRUPO = A.CD_GRUPO
			AND T.CD_PROD = A.CD_PROD
    WHERE 
		VLR_BASE > 0
        AND A.CD_EMP IS NULL
        AND DT_PRECO_BASE >= @DT_BASE 
        AND ISNULL(A.RODAR_IMEDIATO,0) = @RODARIMEDIATO 
		 
     PRINT 'Carregou os produtos para atualizacao - Time '+CONVERT(VARCHAR, GETDATE(), 108);

	 
     /***********************************************************************************************************************************/
     /***		PRECO ESPECIAL POR LOJA - MAJORACAO POR PAPEL																	   *****/
     /***********************************************************************************************************************************/

     --Inserindo majoracao por papel=>Categoria=>Filial
	INSERT INTO 
		#TMP_MAJORADO
			(CD_EMP,
			CD_GRUPO,
			CD_FILIAL,
			CD_PROD,
			PERC_MARGEM,
			TIPO_MAJORACAO,
			CD_GRUPO_MJ)
	SELECT 
		G.CD_EMP
		, G.CD_GRUPO
		, BF.CD_FILIAL
		, ARV.CD_PROD
		, C.PERC_MARGEM
		, 1 AS TIPO
		, 'FILIAL.: ' + CONVERT(VARCHAR(10), BF.CD_FILIAL) 
	FROM
		EST_PRECIFICACAO_GRP_PRECO G
		INNER JOIN EST_PRECIFICACAO_GRP_PRECO_PAPEL_CATEGORIA C ON 
			G.CD_EMP = C.CD_EMP
			AND G.CD_GRUPO = C.CD_GRUPO
		INNER JOIN EST_PRECIFICACAO_GRP_PRECO_FILIAL BF ON 
			G.CD_EMP = BF.CD_EMP
			AND G.CD_GRUPO = BF.CD_GRUPO
		INNER JOIN EST_PROD_EST_ARV_MERCADOLOGICA ARV ON 
			C.CD_EMP = ARV.CD_EMP
			AND C.CD_ARV_MERC_CATEG = ARV.CD_ARV_MERC_CATEG
			AND C.CD_ARV_MERC_PAPEL = ARV.CD_ARV_MERC_PAPEL
	WHERE 
		G.TIPO_GRUPO = 2;

     --Inserindo majoracao por papel=>Categoria=>Bandeira
     --Desde que nao existe a majoracao por papel=>Categoria=>Filial
    INSERT INTO
		#TMP_MAJORADO
			(CD_EMP,
			CD_GRUPO,
			CD_FILIAL,
			CD_PROD,
			PERC_MARGEM,
			TIPO_MAJORACAO,
			CD_GRUPO_MJ)
	SELECT 
		G.CD_EMP
		, G.CD_GRUPO
		, BF.CD_FILIAL
		, ARV.CD_PROD
		, C.PERC_MARGEM
		, 2 AS TIPO
		,'BANDEIRA COD.: ' +  CONVERT(VARCHAR(10),B.CD_BANDEIRA)
	FROM
		EST_PRECIFICACAO_GRP_PRECO G
		INNER JOIN EST_PRECIFICACAO_GRP_PRECO_PAPEL_CATEGORIA C ON 
			G.CD_EMP = C.CD_EMP
			AND G.CD_GRUPO = C.CD_GRUPO
		INNER JOIN EST_PRECIFICACAO_GRP_PRECO_PRC_BANDEIRA GB ON 
			G.CD_EMP = GB.CD_EMP
			AND G.CD_GRUPO = GB.CD_GRUPO
		INNER JOIN PRC_BANDEIRA B ON 
			GB.CD_BANDEIRA = B.CD_BANDEIRA
		INNER JOIN PRC_BANDEIRA_PRC_FILIAL BF ON 
			B.CD_BANDEIRA = BF.CD_BANDEIRA
		INNER JOIN EST_PROD_EST_ARV_MERCADOLOGICA ARV ON 
			C.CD_EMP = ARV.CD_EMP
			AND C.CD_ARV_MERC_CATEG = ARV.CD_ARV_MERC_CATEG
			AND C.CD_ARV_MERC_PAPEL = ARV.CD_ARV_MERC_PAPEL
		LEFT OUTER JOIN #TMP_MAJORADO M ON 
			G.CD_EMP = M.CD_EMP
			AND BF.CD_FILIAL = M.CD_FILIAL
			AND ARV.CD_PROD = M.CD_PROD
	WHERE 
		G.TIPO_GRUPO = 2
		AND M.CD_PROD IS NULL;

     --Inserindo majoracao por papel=>Filial
     --Desde que nao existe a majoracao por papel=>Filial
	INSERT INTO 
		#TMP_MAJORADO
		(CD_EMP,
		CD_GRUPO,
		CD_FILIAL,
		CD_PROD,
		PERC_MARGEM,
		TIPO_MAJORACAO,
		CD_GRUPO_MJ)
    SELECT 
		G.CD_EMP
		, G.CD_GRUPO
		, GF.CD_FILIAL
		, ARV.CD_PROD
		, GP.PERC_MARGEM
		, 3 AS TIPO
		, 'PAPEL COD.: ' + CONVERT(VARCHAR(10),ARV.CD_ARV_MERC_PAPEL)
    FROM
		EST_PRECIFICACAO_GRP_PRECO G
		INNER JOIN EST_PRECIFICACAO_GRP_PRECO_PAPEL GP ON 
			G.CD_EMP = GP.CD_EMP
			AND G.CD_GRUPO = GP.CD_GRUPO
		INNER JOIN EST_PROD_EST_ARV_MERCADOLOGICA ARV ON 
			GP.CD_ARV_MERC_PAPEL = ARV.CD_ARV_MERC_PAPEL
			AND GP.CD_EMP = ARV.CD_EMP
		INNER JOIN EST_PRECIFICACAO_GRP_PRECO_FILIAL GF ON 
			G.CD_EMP = GF.CD_EMP
			AND G.CD_GRUPO = GF.CD_GRUPO
		LEFT OUTER JOIN #TMP_MAJORADO M ON 
			G.CD_EMP = M.CD_EMP
			AND GF.CD_FILIAL = M.CD_FILIAL
			AND ARV.CD_PROD = M.CD_PROD
    WHERE 
		G.TIPO_GRUPO = 1
        AND M.CD_PROD IS NULL;
    PRINT 'Carregou os percentuais de majoracao- Time '+CONVERT(VARCHAR, GETDATE(), 108); 
    /***********************************************************************************************************************************/
    /***		PRODUTOS KIT CUJO PRECO DOS SEUS ITENS FORAM ALTERADOS 											*****/
    /***********************************************************************************************************************************/

    INSERT INTO 
		#TMP_PROD_KIT
    SELECT DISTINCT
		ATL.CD_EMP
		, ATL.CD_GRUPO
		, KIT_CPL.CD_PROD
		, ATL.DT_ATUALIZACAO
		, PRF.CD_USU
    FROM
		EST_PROD_PRECIFICACAO_PRECO_ATUALIZACAO AS ATL
		INNER JOIN EST_PROD_PRECIFICACAO_PRECO AS PRF ON 
			ATL.CD_EMP = PRF.CD_EMP
			AND ATL.CD_GRUPO = PRF.CD_GRUPO
			AND ATL.CD_PROD = PRF.CD_PROD
		INNER JOIN EST_PROD_PRECIFICACAO_KIT_CPL KIT_CPL ON 
			ATL.CD_EMP = KIT_CPL.CD_EMP
			AND ATL.CD_PROD = KIT_CPL.CD_PROD_IT
    WHERE 
		ATL.ATUALIZADO = 0
		AND ATL.DT_ATUALIZACAO <= @DT_BASE 
        AND ATL.RODAR_IMEDIATO = CASE WHEN @RODARIMEDIATO = 1 THEN 
									@RODARIMEDIATO
								ELSE 
									ATL.RODAR_IMEDIATO
                                END;

     PRINT 'Identificou os produtos que sofreram alteracao e que compoe algum kit - Time '+CONVERT(VARCHAR, GETDATE(), 108);
	   
     /***********************************************************************************************************************************/
     /***							 ATUALIZACAO DOS PRECOS TABELA																	 ***/
     /***********************************************************************************************************************************/

    IF @CONSULTA = 0
		BEGIN
			--Atualizando com majoracao
			DECLARE @CD_GRUPO_MJ VARCHAR(100)
			DECLARE @CD_GRUPO INT
			DECLARE @CD_ALT_PRECO INT

			/***********************************************************************************************************************************/
			/***							 ATUALIZANDO PRECO COM MAJORACAO	     														 ***/
			/***********************************************************************************************************************************/
			DECLARE 
				CProcPrecoMajoracao 
			CURSOR FAST_FORWARD FOR
			SELECT 
				CD_GRUPO_MJ,
				CD_GRUPO
			FROM
				#TMP_MAJORADO
			GROUP BY
				CD_GRUPO_MJ,
				CD_GRUPO

			OPEN CProcPrecoMajoracao
		
			FETCH NEXT FROM CProcPrecoMajoracao INTO @CD_GRUPO_MJ, @CD_GRUPO
			WHILE @@FETCH_STATUS=0
				BEGIN
					PRINT 'Analise majoracao ' + convert(varchar(5), @CD_GRUPO_MJ) + '(' + CONVERT(VARCHAR(8), GETDATE(), 114) + ')...'

					SET @CD_ALT_PRECO= COALESCE((SELECT MAX(CD_ALT_PRECO) FROM EST_PROD_PRECO_ALT WHERE CD_EMP=1), 0) + 1
					select @CD_GRUPO_MJ
					INSERT INTO 
						EST_PROD_PRECO_ALT
							(CD_EMP,
							CD_ALT_PRECO,
							TP_ALT_PRECO,
							ZERO_OFERTA,
							DT_CAD,
							CD_USU,
							DS_ALT_PRECO,
							APLICADO,
							DT_APLICACAO,
							DT_AGENDADA,
							ORIGEM_PRECO,
							APLICAR_PRECO_FAMILIA,
							PRECO_AGENDADO,
							DT_FIM_AGENDA)
					SELECT
						TOP 1 ATL.CD_EMP,
						@CD_ALT_PRECO,
						0 AS TP_ALT_PRECO,
						0 AS ZERO_OFERTA,
						CONVERT(CHAR(10),GETDATE(),112) DT_CAD,
						PRF.CD_USU,
						'ALTERACAO CRIADA PARTIR DA PRECIFICACAO PELA MAJORACAO ' + @CD_GRUPO_MJ DS_ALT_PRECO,
						0 AS APLICADO,
						CONVERT(CHAR(10),GETDATE(),112) AS DT_APLICACAO,
						CONVERT(CHAR(10),GETDATE(),112),
						0 AS ORIGEM_PRECO,
						0 AS APLICAT_PRECO_FAMILIA,
						0 AS PRECO_AGENDADO,
						NULL DT_FIM_AGENDA
					FROM 
						EST_PROD_PRECIFICACAO_PRECO_ATUALIZACAO AS ATL
						INNER JOIN EST_PROD_PRECIFICACAO_PRECO AS PRF ON 
							ATL.CD_EMP = PRF.CD_EMP AND 
							ATL.CD_GRUPO = PRF.CD_GRUPO AND 
							ATL.CD_PROD = PRF.CD_PROD
						INNER JOIN #TMP_MAJORADO AS MJ ON 
							ATL.CD_EMP = MJ.CD_EMP AND 
							ATL.CD_PROD = MJ.CD_PROD
						WHERE 
							ATL.ATUALIZADO = 0
							AND ATL.DT_ATUALIZACAO <= @DT_BASE 
							AND ATL.RODAR_IMEDIATO = CASE WHEN @RODARIMEDIATO = 1 THEN 
														@RODARIMEDIATO
													ELSE 
														ATL.RODAR_IMEDIATO
													END
							AND MJ.CD_GRUPO_MJ = @CD_GRUPO_MJ
							AND MJ.CD_GRUPO = @CD_GRUPO; 

					INSERT INTO 
						EST_PROD_PRECO_ALT_CPL
							(CD_EMP,
							CD_ALT_PRECO,
							CD_PROD,
							VLR_TABELA,
							VLR_OFERTA,
							VLR_CUSTO,
							CD_FILIAL,
							CD_NF,
							TP_NIVEL_PERC,
							PERC_MARGEM,
							DS_PERC_MARGEM,
							TP_CUSTO,
							DS_TP_CUSTO,
							VLR_TABELA_ORIGINAL,
							VLR_TABELA_VIGENTE,
							VLR_OFERTA_VIGENTE,
							CD_ALT_PRECO_ANTERIOR,
							PERC_VARIACAO_AUMENTO)   
					SELECT DISTINCT 
						ATL.CD_EMP,
						@CD_ALT_PRECO,
						ATL.CD_PROD,
						ROUND(PRF.VLR_BASE * ISNULL((100 + MJ.PERC_MARGEM) / 100, 1), 2),
						0 AS VLR_OFERTA,
						0 AS VLR_CUSTO,
						0 AS CD_FILIAL,
						0 AS CD_NF,
						0 AS TP_NIVEL_PERC,
						0 AS PERC_MARGEM,
						'' AS DS_PERC_MARGEM,
						0 AS TP_CUSTO,
						'' AS DS_TP_CUSTO,
						0 AS VLR_TABELA_ORIGINAL,
						0 AS VLR_TABELA_VIGENTE,
						0 AS VLR_OFERTA_VIGENTE,
						0,
						0 AS PERC_VARIACAO_AUMENTO
					FROM 
						EST_PROD_PRECIFICACAO_PRECO_ATUALIZACAO AS ATL 
						INNER JOIN EST_PROD_PRECIFICACAO_PRECO AS PRF ON 
							ATL.CD_EMP = PRF.CD_EMP AND 
							ATL.CD_GRUPO = PRF.CD_GRUPO AND 
							ATL.CD_PROD = PRF.CD_PROD
						INNER JOIN EST_PRECIFICACAO_GRP_PRECO_FILIAL AS FLL ON 
							ATL.CD_EMP = FLL.CD_EMP AND 
							ATL.CD_GRUPO = FLL.CD_GRUPO
						INNER JOIN #TMP_MAJORADO AS MJ ON 
							ATL.CD_EMP = MJ.CD_EMP AND 
							ATL.CD_PROD = MJ.CD_PROD
					WHERE 
						ATL.ATUALIZADO = 0
						AND ATL.DT_ATUALIZACAO <= @DT_BASE 
						AND ATL.RODAR_IMEDIATO = CASE WHEN @RODARIMEDIATO = 1 THEN 
													@RODARIMEDIATO
												ELSE 
													ATL.RODAR_IMEDIATO
												END
						AND MJ.CD_GRUPO_MJ=@CD_GRUPO_MJ
						AND MJ.CD_GRUPO = @CD_GRUPO; 

					INSERT INTO 
						EST_PROD_PRECO_ALT_PRC_FILIAL	
							(CD_EMP,
							CD_ALT_PRECO,
							CD_FILIAL,
							CD_GRUPO)
					SELECT DISTINCT 
						ATL.CD_EMP,
						@CD_ALT_PRECO,
						FLL.CD_FILIAL,
						FLL.CD_GRUPO
					FROM 
						EST_PROD_PRECIFICACAO_PRECO_ATUALIZACAO AS ATL 
						INNER JOIN EST_PRECIFICACAO_GRP_PRECO_FILIAL AS FLL ON 
							ATL.CD_EMP = FLL.CD_EMP
						INNER JOIN #TMP_MAJORADO AS MJ ON 
							ATL.CD_EMP = MJ.CD_EMP AND 
							FLL.CD_GRUPO = MJ.CD_GRUPO AND 
							ATL.CD_PROD = MJ.CD_PROD
					WHERE 
						ATL.ATUALIZADO = 0
						AND ATL.DT_ATUALIZACAO <= @DT_BASE 
						AND ATL.RODAR_IMEDIATO = CASE WHEN @RODARIMEDIATO = 1 THEN 
													@RODARIMEDIATO
												ELSE 
													ATL.RODAR_IMEDIATO
												END
						AND MJ.CD_GRUPO_MJ = @CD_GRUPO_MJ
						AND MJ.CD_GRUPO = @CD_GRUPO;

	
					FETCH NEXT FROM CProcPrecoMajoracao INTO @CD_GRUPO_MJ, @CD_GRUPO
				end

			PRINT 'Concluído.'
			CLOSE CProcPrecoMajoracao
			DEALLOCATE CProcPrecoMajoracao

			/***********************************************************************************************************************************/
			/***							 ATUALIZANDO PRECO SEM MAJORACAO	     														 ***/
			/***********************************************************************************************************************************/

			Print 'Atualizando preco sem majoracao ....'
			 
			DECLARE 
				CProcPrecoNormal 
			CURSOR FAST_FORWARD FOR
			SELECT  
				CD_GRUPO
			FROM
				EST_PROD_PRECIFICACAO_PRECO_ATUALIZACAO 
			where
					DT_ATUALIZACAO <= @DT_BASE 
					AND RODAR_IMEDIATO = @RODARIMEDIATO
			GROUP BY CD_GRUPO

			OPEN CProcPrecoNormal
		
			FETCH NEXT FROM CProcPrecoNormal INTO @CD_GRUPO
			WHILE @@FETCH_STATUS=0
				BEGIN

				SET @CD_ALT_PRECO=0
				SET @CD_ALT_PRECO= COALESCE((SELECT MAX(CD_ALT_PRECO) FROM EST_PROD_PRECO_ALT WHERE CD_EMP=1), 0) + 1
			
				INSERT INTO EST_PROD_PRECO_ALT
					(CD_EMP, CD_ALT_PRECO, TP_ALT_PRECO, ZERO_OFERTA, DT_CAD,
							CD_USU, DS_ALT_PRECO, APLICADO, DT_APLICACAO, DT_AGENDADA,
							ORIGEM_PRECO, APLICAR_PRECO_FAMILIA, PRECO_AGENDADO, DT_FIM_AGENDA)
				SELECT TOP 
					1 ATL.CD_EMP,
					@CD_ALT_PRECO,
					0 AS TP_ALT_PRECO,
					0 AS ZERO_OFERTA,
					CONVERT(CHAR(10),GETDATE(),112) DT_CAD,
					PRF.CD_USU,
					'ALTERACAO CRIADA A PARTIR DA PRECIFICACAO SEM MAJORACAO' DS_ALT_PRECO,
					0 AS APLICADO,
					CONVERT(CHAR(10),GETDATE(),112) AS DT_APLICACAO,
					CONVERT(CHAR(10),GETDATE(),112),
					0 AS ORIGEM_PRECO,
					0 AS APLICAT_PRECO_FAMILIA,
					0 AS PRECO_AGENDADO,
					NULL DT_FIM_AGENDA
				FROM 
					EST_PROD_PRECIFICACAO_PRECO_ATUALIZACAO AS ATL
					INNER JOIN EST_PROD_PRECIFICACAO_PRECO AS PRF ON 
						ATL.CD_EMP = PRF.CD_EMP AND 
						ATL.CD_GRUPO = PRF.CD_GRUPO AND 
						ATL.CD_PROD = PRF.CD_PROD 
				WHERE 
					ATL.ATUALIZADO = 0
					and ATL.CD_GRUPO =@CD_GRUPO
					AND ATL.DT_ATUALIZACAO <= @DT_BASE 
					AND ISNULL(ATL.RODAR_IMEDIATO,0) = @RODARIMEDIATO


				INSERT INTO  EST_PROD_PRECO_ALT_CPL (CD_EMP, CD_ALT_PRECO, CD_PROD, VLR_TABELA, VLR_OFERTA,
														VLR_CUSTO, CD_FILIAL, CD_NF, TP_NIVEL_PERC, PERC_MARGEM, DS_PERC_MARGEM, TP_CUSTO,
														DS_TP_CUSTO, VLR_TABELA_ORIGINAL, VLR_TABELA_VIGENTE, VLR_OFERTA_VIGENTE, CD_ALT_PRECO_ANTERIOR,PERC_VARIACAO_AUMENTO)   
				SELECT DISTINCT 
					ATL.CD_EMP,
					@CD_ALT_PRECO,
					ATL.CD_PROD,
					ROUND(PRF.VLR_BASE, 2),
					0 AS VLR_OFERTA,
					0 AS VLR_CUSTO,
					0 AS CD_FILIAL,
					0 AS CD_NF,
					0 AS TP_NIVEL_PERC,
					0 AS PERC_MARGEM,
					'' AS DS_PERC_MARGEM,
					0 AS TP_CUSTO,
					'' AS DS_TP_CUSTO,
					0 AS VLR_TABELA_ORIGINAL,
					0 AS VLR_TABELA_VIGENTE,
					0 AS VLR_OFERTA_VIGENTE,
					0,
					0 AS PERC_VARIACAO_AUMENTO
				FROM 
					EST_PROD_PRECIFICACAO_PRECO_ATUALIZACAO AS ATL INNER JOIN EST_PROD_PRECIFICACAO_PRECO AS PRF ON 
						ATL.CD_EMP = PRF.CD_EMP AND 
						ATL.CD_GRUPO = PRF.CD_GRUPO AND 
						ATL.CD_PROD = PRF.CD_PROD
					INNER JOIN EST_PRECIFICACAO_GRP_PRECO_FILIAL AS FLL ON 
						ATL.CD_EMP = FLL.CD_EMP AND 
						ATL.CD_GRUPO = FLL.CD_GRUPO
					LEFT OUTER JOIN  #TMP_MAJORADO AS MJ ON 
						ATL.CD_EMP = MJ.CD_EMP  					
						AND FLL.CD_FILIAL = Mj.CD_FILIAL 
						AND ATL.CD_PROD	  = MJ.CD_PROD
				WHERE 
					ATL.ATUALIZADO = 0
					and ATL.CD_GRUPO =@CD_GRUPO
					AND ATL.DT_ATUALIZACAO <= @DT_BASE 
					AND ISNULL(ATL.RODAR_IMEDIATO,0) = @RODARIMEDIATO
					AND MJ.CD_GRUPO_MJ IS NULL;



				INSERT INTO  EST_PROD_PRECO_ALT_PRC_FILIAL	 (CD_EMP, CD_ALT_PRECO, CD_FILIAL, CD_GRUPO)
				SELECT DISTINCT 
					ATL.CD_EMP,
					@CD_ALT_PRECO,
					FLL.CD_FILIAL,
					FLL.CD_GRUPO
				FROM 
					EST_PROD_PRECIFICACAO_PRECO_ATUALIZACAO AS ATL 
					INNER JOIN EST_PRECIFICACAO_GRP_PRECO_FILIAL AS FLL ON 
						ATL.CD_EMP = FLL.CD_EMP AND 
						ATL.CD_GRUPO = FLL.CD_GRUPO
					LEFT OUTER JOIN #TMP_MAJORADO AS MJ ON 
						ATL.CD_EMP = MJ.CD_EMP  
						AND FLL.CD_FILIAL = Mj.CD_FILIAL
						AND ATL.CD_PROD = MJ.CD_PROD
				WHERE 
					ATL.ATUALIZADO = 0
					AND ATL.CD_GRUPO =@CD_GRUPO
					AND ATL.DT_ATUALIZACAO <= @DT_BASE 
					AND ATL.RODAR_IMEDIATO = CASE WHEN @RODARIMEDIATO = 1 THEN 
												@RODARIMEDIATO
											ELSE 
												ATL.RODAR_IMEDIATO
											END
					AND MJ.CD_GRUPO_MJ IS NULL; 

		  			FETCH NEXT FROM CProcPrecoNormal INTO @CD_GRUPO
			end

			PRINT 'Concluído.'
			CLOSE CProcPrecoNormal
			DEALLOCATE CProcPrecoNormal

			/***********************************************************************************************************************************/
			/***							 MARCA COMO ATUALIZADO																			 ***/
			/***********************************************************************************************************************************/

			UPDATE 
				ATL
			SET
				ATUALIZADO = 1
			FROM 
				EST_PROD_PRECIFICACAO_PRECO_ATUALIZACAO AS ATL
				INNER JOIN EST_PROD_PRECIFICACAO_PRECO AS PRF ON 
					ATL.CD_EMP = PRF.CD_EMP
					AND ATL.CD_GRUPO = PRF.CD_GRUPO
					AND ATL.CD_PROD = PRF.CD_PROD
				INNER JOIN EST_PRECIFICACAO_GRP_PRECO_FILIAL AS FLL ON 
					ATL.CD_EMP = FLL.CD_EMP
					AND ATL.CD_GRUPO = FLL.CD_GRUPO
				INNER JOIN EST_PROD_PRECO AS PRC ON 
					FLL.CD_EMP = PRC.CD_EMP
					AND FLL.CD_FILIAL = PRC.CD_FILIAL
					AND ATL.CD_PROD = PRC.CD_PROD
			WHERE 
				ATL.ATUALIZADO = 0
				AND ATL.DT_ATUALIZACAO <= @DT_BASE 
				AND ATL.RODAR_IMEDIATO = CASE WHEN @RODARIMEDIATO = 1 THEN 
											@RODARIMEDIATO
										ELSE 
											ATL.RODAR_IMEDIATO
										END;
		END;
	ELSE
		BEGIN
			SELECT 
				PRC.CD_FILIAL
				, PRC.CD_PROD
				, PD.DS_PROD
				, PRC.VLR_TABELA VLR_ATUAL
				, PRF.VLR_BASE VLR_CALC
				, CONVERT( MONEY, ROUND(PRF.VLR_BASE * ISNULL((100 + MJ.PERC_MARGEM) / 100, 1), 2)) VLR_CALC_MAJORADO
				, ATL.DT_ATUALIZACAO
				, PRF.CD_USU
				, MJ.TIPO_MAJORACAO
				, CASE WHEN MJ.TIPO_MAJORACAO = 0 THEN 
					'SEM MAJORACAO'
				WHEN MJ.TIPO_MAJORACAO = 1 THEN 
					'MAJORACAO PAPEL=>CATEGORIA=>FILIAL'
				WHEN MJ.TIPO_MAJORACAO = 2 THEN 
					'MAJORACAO PAPEL=>CATEGORIA=>BANDEIRA'
				WHEN MJ.TIPO_MAJORACAO = 3 THEN 
					'MAJORACAO PAPEL=>FILIAL'
				END
			FROM
				EST_PROD_PRECIFICACAO_PRECO_ATUALIZACAO AS ATL
				INNER JOIN EST_PROD_PRECIFICACAO_PRECO AS PRF ON 
					ATL.CD_EMP = PRF.CD_EMP
					AND ATL.CD_GRUPO = PRF.CD_GRUPO
					AND ATL.CD_PROD = PRF.CD_PROD
				INNER JOIN EST_PRECIFICACAO_GRP_PRECO_FILIAL AS FLL ON 
					ATL.CD_EMP = FLL.CD_EMP
					AND ATL.CD_GRUPO = FLL.CD_GRUPO
				INNER JOIN EST_PROD_PRECO AS PRC ON 
					FLL.CD_EMP = PRC.CD_EMP
					AND FLL.CD_FILIAL = PRC.CD_FILIAL
					AND ATL.CD_PROD = PRC.CD_PROD
				INNER JOIN EST_PROD AS PD ON 
					PRC.CD_EMP = PD.CD_EMP
					AND PRC.CD_PROD = PD.CD_PROD
				LEFT JOIN #TMP_MAJORADO AS MJ ON 
					PRC.CD_EMP = MJ.CD_EMP
					AND PRC.CD_FILIAL = MJ.CD_FILIAL
					AND PRC.CD_PROD = MJ.CD_PROD
			WHERE 
				ATL.ATUALIZADO = 0
				AND ATL.DT_ATUALIZACAO <= @DT_BASE 
				AND ATL.RODAR_IMEDIATO = CASE WHEN @RODARIMEDIATO = 1 THEN 
											@RODARIMEDIATO
                                        ELSE 
											ATL.RODAR_IMEDIATO
                                        END;
		END;

	/***********************************************************************************************************************************/
	/***							 REMOVE TABELAS TEMPORARIAS  																	 ***/
	/***********************************************************************************************************************************/

	DELETE
		P
	FROM
		EST_PROD_CPL_EST_PROD_PRECO_SEM_CADASTRO P
		INNER JOIN #RsProdPend pend on
			P.CD_EMP = pend.CD_EMP AND
			P.CD_FILIAL = pend.CD_FILIAL AND
			P.CD_PROD = pend.CD_PROD

	DROP TABLE #TMP_MAJORADO;
    DROP TABLE #TMP_PROD_KIT;
	DROP TABLE #RsProdPend;
    PRINT 'Fim da rotina - Time '+CONVERT(VARCHAR, GETDATE(), 108);

	/***********************************************************************************************************************************/

    DELETE FROM 
		EST_PROD_PRECIFICACAO_PRECO_ATUALIZACAO
    WHERE 
		ATUALIZADO = 1  
		AND RODAR_IMEDIATO = CASE WHEN @RODARIMEDIATO = 1 THEN 
								@RODARIMEDIATO
                            ELSE 
								RODAR_IMEDIATO
                            END;

	SET @DT_BASE = DATEADD(DAY, -2, GETDATE());
	DELETE
		EST_PROD_PRECIFICACAO_PRECO_ATUALIZACAO
    WHERE
		DT_ATUALIZACAO <= @DT_BASE
		AND RODAR_IMEDIATO = CASE WHEN @RODARIMEDIATO = 1 THEN
								@RODARIMEDIATO
                            ELSE
								RODAR_IMEDIATO
                            END;

IF @CONSULTA = 0
	BEGIN
		EXEC P_EST_PROD_PRECO_CUSTO_MEDIO_GERACAO_EMPRESA;
		EXEC P_EST_PROD_PRECO_ALT_PROGRAMADO;
		EXEC P_EST_PROD_PRECO_ALTERACAO;
	END
